/** @file lst.cpp
 *
 *  Implementation of GiNaC's lst. */

/*
 *  This file was generated automatically by container.pl.
 *  Please do not modify it directly, edit the perl script instead!
 *  container.pl options: $CONTAINER=lst
 *                        $STLHEADER=list
 *                        $reserve=0
 *                        $prepend=1
 *                        $let_op=1
 *                        $open_bracket={
 *                        $close_bracket=}
 *                        $maxargs=16
 *
 *  GiNaC Copyright (C) 1999-2003 Johannes Gutenberg University Mainz, Germany
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <iostream>
#include <stdexcept>

#include "lst.h"
#include "ex.h"
#include "print.h"
#include "archive.h"

namespace GiNaC {

GINAC_IMPLEMENT_REGISTERED_CLASS(lst, basic)

#define RESERVE(s,size) // no reserve needed for list

//////////
// default ctor, dtor, copy ctor, assignment operator and helpers
//////////

// public

lst::lst() : basic(TINFO_lst) {}

// protected

void lst::copy(lst const & other)
{
	inherited::copy(other);
	seq=other.seq;
}

void lst::destroy(bool call_parent)
{
	seq.clear();
	if (call_parent) inherited::destroy(call_parent);
}

//////////
// other ctors
//////////

// public

lst::lst(exlist const & s, bool discardable) :  basic(TINFO_lst)
{
	if (discardable) {
		seq.swap(const_cast<exlist &>(s));
	} else {
		seq=s;
	}
}

lst::lst(exlist * vp) : basic(TINFO_lst)
{
	GINAC_ASSERT(vp!=0);
	seq.swap(*vp);
	delete vp;
}

lst::lst(const ex & param1) : basic(TINFO_lst)
{
	RESERVE(seq,1);
	seq.push_back(param1);
}
lst::lst(const ex & param1, const ex & param2) : basic(TINFO_lst)
{
	RESERVE(seq,2);
	seq.push_back(param1);
	seq.push_back(param2);
}
lst::lst(const ex & param1, const ex & param2, const ex & param3) : basic(TINFO_lst)
{
	RESERVE(seq,3);
	seq.push_back(param1);
	seq.push_back(param2);
	seq.push_back(param3);
}
lst::lst(const ex & param1, const ex & param2, const ex & param3, const ex & param4) : basic(TINFO_lst)
{
	RESERVE(seq,4);
	seq.push_back(param1);
	seq.push_back(param2);
	seq.push_back(param3);
	seq.push_back(param4);
}
lst::lst(const ex & param1, const ex & param2, const ex & param3, const ex & param4, const ex & param5) : basic(TINFO_lst)
{
	RESERVE(seq,5);
	seq.push_back(param1);
	seq.push_back(param2);
	seq.push_back(param3);
	seq.push_back(param4);
	seq.push_back(param5);
}
lst::lst(const ex & param1, const ex & param2, const ex & param3, const ex & param4, const ex & param5, const ex & param6) : basic(TINFO_lst)
{
	RESERVE(seq,6);
	seq.push_back(param1);
	seq.push_back(param2);
	seq.push_back(param3);
	seq.push_back(param4);
	seq.push_back(param5);
	seq.push_back(param6);
}
lst::lst(const ex & param1, const ex & param2, const ex & param3, const ex & param4, const ex & param5, const ex & param6, const ex & param7) : basic(TINFO_lst)
{
	RESERVE(seq,7);
	seq.push_back(param1);
	seq.push_back(param2);
	seq.push_back(param3);
	seq.push_back(param4);
	seq.push_back(param5);
	seq.push_back(param6);
	seq.push_back(param7);
}
lst::lst(const ex & param1, const ex & param2, const ex & param3, const ex & param4, const ex & param5, const ex & param6, const ex & param7, const ex & param8) : basic(TINFO_lst)
{
	RESERVE(seq,8);
	seq.push_back(param1);
	seq.push_back(param2);
	seq.push_back(param3);
	seq.push_back(param4);
	seq.push_back(param5);
	seq.push_back(param6);
	seq.push_back(param7);
	seq.push_back(param8);
}
lst::lst(const ex & param1, const ex & param2, const ex & param3, const ex & param4, const ex & param5, const ex & param6, const ex & param7, const ex & param8, const ex & param9) : basic(TINFO_lst)
{
	RESERVE(seq,9);
	seq.push_back(param1);
	seq.push_back(param2);
	seq.push_back(param3);
	seq.push_back(param4);
	seq.push_back(param5);
	seq.push_back(param6);
	seq.push_back(param7);
	seq.push_back(param8);
	seq.push_back(param9);
}
lst::lst(const ex & param1, const ex & param2, const ex & param3, const ex & param4, const ex & param5, const ex & param6, const ex & param7, const ex & param8, const ex & param9, const ex & param10) : basic(TINFO_lst)
{
	RESERVE(seq,10);
	seq.push_back(param1);
	seq.push_back(param2);
	seq.push_back(param3);
	seq.push_back(param4);
	seq.push_back(param5);
	seq.push_back(param6);
	seq.push_back(param7);
	seq.push_back(param8);
	seq.push_back(param9);
	seq.push_back(param10);
}
lst::lst(const ex & param1, const ex & param2, const ex & param3, const ex & param4, const ex & param5, const ex & param6, const ex & param7, const ex & param8, const ex & param9, const ex & param10, const ex & param11) : basic(TINFO_lst)
{
	RESERVE(seq,11);
	seq.push_back(param1);
	seq.push_back(param2);
	seq.push_back(param3);
	seq.push_back(param4);
	seq.push_back(param5);
	seq.push_back(param6);
	seq.push_back(param7);
	seq.push_back(param8);
	seq.push_back(param9);
	seq.push_back(param10);
	seq.push_back(param11);
}
lst::lst(const ex & param1, const ex & param2, const ex & param3, const ex & param4, const ex & param5, const ex & param6, const ex & param7, const ex & param8, const ex & param9, const ex & param10, const ex & param11, const ex & param12) : basic(TINFO_lst)
{
	RESERVE(seq,12);
	seq.push_back(param1);
	seq.push_back(param2);
	seq.push_back(param3);
	seq.push_back(param4);
	seq.push_back(param5);
	seq.push_back(param6);
	seq.push_back(param7);
	seq.push_back(param8);
	seq.push_back(param9);
	seq.push_back(param10);
	seq.push_back(param11);
	seq.push_back(param12);
}
lst::lst(const ex & param1, const ex & param2, const ex & param3, const ex & param4, const ex & param5, const ex & param6, const ex & param7, const ex & param8, const ex & param9, const ex & param10, const ex & param11, const ex & param12, const ex & param13) : basic(TINFO_lst)
{
	RESERVE(seq,13);
	seq.push_back(param1);
	seq.push_back(param2);
	seq.push_back(param3);
	seq.push_back(param4);
	seq.push_back(param5);
	seq.push_back(param6);
	seq.push_back(param7);
	seq.push_back(param8);
	seq.push_back(param9);
	seq.push_back(param10);
	seq.push_back(param11);
	seq.push_back(param12);
	seq.push_back(param13);
}
lst::lst(const ex & param1, const ex & param2, const ex & param3, const ex & param4, const ex & param5, const ex & param6, const ex & param7, const ex & param8, const ex & param9, const ex & param10, const ex & param11, const ex & param12, const ex & param13, const ex & param14) : basic(TINFO_lst)
{
	RESERVE(seq,14);
	seq.push_back(param1);
	seq.push_back(param2);
	seq.push_back(param3);
	seq.push_back(param4);
	seq.push_back(param5);
	seq.push_back(param6);
	seq.push_back(param7);
	seq.push_back(param8);
	seq.push_back(param9);
	seq.push_back(param10);
	seq.push_back(param11);
	seq.push_back(param12);
	seq.push_back(param13);
	seq.push_back(param14);
}
lst::lst(const ex & param1, const ex & param2, const ex & param3, const ex & param4, const ex & param5, const ex & param6, const ex & param7, const ex & param8, const ex & param9, const ex & param10, const ex & param11, const ex & param12, const ex & param13, const ex & param14, const ex & param15) : basic(TINFO_lst)
{
	RESERVE(seq,15);
	seq.push_back(param1);
	seq.push_back(param2);
	seq.push_back(param3);
	seq.push_back(param4);
	seq.push_back(param5);
	seq.push_back(param6);
	seq.push_back(param7);
	seq.push_back(param8);
	seq.push_back(param9);
	seq.push_back(param10);
	seq.push_back(param11);
	seq.push_back(param12);
	seq.push_back(param13);
	seq.push_back(param14);
	seq.push_back(param15);
}
lst::lst(const ex & param1, const ex & param2, const ex & param3, const ex & param4, const ex & param5, const ex & param6, const ex & param7, const ex & param8, const ex & param9, const ex & param10, const ex & param11, const ex & param12, const ex & param13, const ex & param14, const ex & param15, const ex & param16) : basic(TINFO_lst)
{
	RESERVE(seq,16);
	seq.push_back(param1);
	seq.push_back(param2);
	seq.push_back(param3);
	seq.push_back(param4);
	seq.push_back(param5);
	seq.push_back(param6);
	seq.push_back(param7);
	seq.push_back(param8);
	seq.push_back(param9);
	seq.push_back(param10);
	seq.push_back(param11);
	seq.push_back(param12);
	seq.push_back(param13);
	seq.push_back(param14);
	seq.push_back(param15);
	seq.push_back(param16);
}


//////////
// archiving
//////////

/** Construct object from archive_node. */
lst::lst(const archive_node &n, const lst &sym_lst) : inherited(n, sym_lst)
{
	for (unsigned int i=0; true; i++) {
		ex e;
		if (n.find_ex("seq", e, sym_lst, i))
			seq.push_back(e);
		else
			break;
	}
}

/** Unarchive the object. */
ex lst::unarchive(const archive_node &n, const lst &sym_lst)
{
	return (new lst(n, sym_lst))->setflag(status_flags::dynallocated);
}

/** Archive the object. */
void lst::archive(archive_node &n) const
{
	inherited::archive(n);
	exlist::const_iterator i = seq.begin(), end = seq.end();
	while (i != end) {
		n.add_ex("seq", *i);
		++i;
	}
}

//////////
// functions overriding virtual functions from base classes
//////////

// public

void lst::print(const print_context & c, unsigned level) const
{
	if (is_a<print_tree>(c)) {

		c.s << std::string(level, ' ') << class_name()
		    << std::hex << ", hash=0x" << hashvalue << ", flags=0x" << flags << std::dec
		    << ", nops=" << nops()
		    << std::endl;
		unsigned delta_indent = static_cast<const print_tree &>(c).delta_indent;
		exlist::const_iterator i = seq.begin(), end = seq.end();
		while (i != end) {
			i->print(c, level + delta_indent);
			++i;
		}
		c.s << std::string(level + delta_indent,' ') << "=====" << std::endl;
	} else if (is_a<print_python>(c)) {
		printseq(c, '[', ',', ']', precedence(), precedence()+1);
	} else if (is_a<print_python_repr>(c)) {
		c.s << class_name ();
		printseq(c, '(', ',', ')', precedence(), precedence()+1);
	} else {
		// always print brackets around seq, ignore upper_precedence
		printseq(c, '{', ',', '}', precedence(), precedence()+1);
	}
}

// lst::info() will be implemented by user elsewhere";

unsigned lst::nops() const
{
	return seq.size();
}

ex & lst::let_op(int i)
{
	GINAC_ASSERT(i>=0);
	GINAC_ASSERT(i<nops());

	exlist::iterator it=seq.begin();
	for (int j=0; j<i; j++) {
		++it;
	}
	return *it;
}


ex lst::map(map_function & f) const
{
	// This implementation is here because basic::map() uses let_op()
	// which is not defined for all containers
	exlist s;
	RESERVE(s,seq.size());
	exlist::const_iterator i = seq.begin(), end = seq.end();
	while (i != end) {
		s.push_back(f(*i));
		++i;
	}

	return thislst(s);
}

ex lst::eval(int level) const
{
	if (level==1) {
		return this->hold();
	}
	return thislst(evalchildren(level));
}

ex lst::subs(const lst & ls, const lst & lr, bool no_pattern) const
{
	exlist *vp = subschildren(ls, lr, no_pattern);
	if (vp)
		return ex_to<basic>(thislst(vp)).basic::subs(ls, lr, no_pattern);
	else
		return basic::subs(ls, lr, no_pattern);
}

// protected

int lst::compare_same_type(const basic & other) const
{
	GINAC_ASSERT(is_a<lst>(other));
	lst const & o = static_cast<const lst &>(other);

	exlist::const_iterator it1 = seq.begin(), it1end = seq.end(),
	                        it2 = o.seq.begin(), it2end = o.seq.end();

	while (it1 != it1end && it2 != it2end) {
		int cmpval = it1->compare(*it2);
		if (cmpval)
			return cmpval;
		++it1; ++it2;
	}

	return (it1 == it1end) ? (it2 == it2end ? 0 : -1) : 1;
}

bool lst::is_equal_same_type(const basic & other) const
{
	GINAC_ASSERT(is_a<lst>(other));
	lst const &o = static_cast<const lst &>(other);

	if (seq.size() != o.seq.size())
		return false;

	exlist::const_iterator it1 = seq.begin(), it1end = seq.end(),
	                        it2 = o.seq.begin();

	while (it1 != it1end) {
		if (!it1->is_equal(*it2))
			return false;
		++it1; ++it2;
	}

	return true;
}

//////////
// new virtual functions which can be overridden by derived classes
//////////

// public

lst & lst::append(const ex & b)
{
	ensure_if_modifiable();
	seq.push_back(b);
	return *this;
}

lst & lst::remove_last(void)
{
	ensure_if_modifiable();
	seq.pop_back();
	return *this;
}

lst & lst::prepend(const ex & b)
{
	ensure_if_modifiable();
	seq.push_front(b);
	return *this;
}

lst & lst::remove_first(void)
{
	ensure_if_modifiable();
	seq.pop_front();
	return *this;
}


lst & lst::sort(void)
{
	ensure_if_modifiable();
	seq.sort(ex_is_less());
	return *this;
}

lst & lst::unique(void)
{
	ensure_if_modifiable();
	seq.unique(ex_is_equal());
	return *this;
}


// protected

void lst::printseq(const print_context & c, char openbracket, char delim,
                            char closebracket, unsigned this_precedence,
                            unsigned upper_precedence) const
{
	if (this_precedence <= upper_precedence)
		c.s << openbracket;

	if (!seq.empty()) {
		exlist::const_iterator it = seq.begin(), itend = seq.end();
		--itend;
		while (it != itend) {
			it->print(c, this_precedence);
			c.s << delim;
			++it;
		}
		it->print(c, this_precedence);
	}

	if (this_precedence <= upper_precedence)
		c.s << closebracket;
}

ex lst::thislst(exlist const & v) const
{
	return lst(v);
}

ex lst::thislst(exlist * vp) const
{
	return lst(vp);
}

//////////
// non-virtual functions in this class
//////////

// public

// none

// protected

bool lst::is_canonical() const
{
	if (seq.size()<=1) { return 1; }

	exlist::const_iterator it = seq.begin(), itend = seq.end();
	exlist::const_iterator it_last=it;
	for (++it; it!=itend; it_last=it, ++it) {
		if (it_last->compare(*it)>0) {
			if (it_last->compare(*it)>0) {
				std::cout << *it_last << ">" << *it << "\n";
				return 0;
			}
		}
	}
	return 1;
}


exlist lst::evalchildren(int level) const
{
	exlist s;
	RESERVE(s,seq.size());

	if (level==1) {
		return seq;
	}
	if (level == -max_recursion_level) {
		throw(std::runtime_error("max recursion level reached"));
	}
	--level;
	exlist::const_iterator it = seq.begin(), itend = seq.end();
	while (it != itend) {
		s.push_back(it->eval(level));
		++it;
	}
	return s;
}

exlist * lst::subschildren(const lst & ls, const lst & lr, bool no_pattern) const
{
	// returns a NULL pointer if nothing had to be substituted
	// returns a pointer to a newly created epvector otherwise
	// (which has to be deleted somewhere else)

	exlist::const_iterator cit = seq.begin(), end = seq.end();
	while (cit != end) {
		const ex & subsed_ex = cit->subs(ls, lr, no_pattern);
		if (!are_ex_trivially_equal(*cit, subsed_ex)) {

			// something changed, copy seq, subs and return it
			exlist *s=new exlist;
			RESERVE(*s, seq.size());

			// copy parts of seq which are known not to have changed
			exlist::const_iterator cit2 = seq.begin();
			while (cit2 != cit) {
				s->push_back(*cit2);
				++cit2;
			}

			// copy first changed element
			s->push_back(subsed_ex);
			++cit2;

			// copy rest
			while (cit2 != end) {
				s->push_back(cit2->subs(ls, lr, no_pattern));
				++cit2;
			}
			return s;
		}
		++cit;
	}
	
	return 0; // nothing has changed
}

} // namespace GiNaC

