/** @file exprseq.h
 *
 *  Definition of GiNaC's exprseq. */

/*
 *  This file was generated automatically by container.pl.
 *  Please do not modify it directly, edit the perl script instead!
 *  container.pl options: $CONTAINER=exprseq
 *                        $STLHEADER=vector
 *                        $reserve=1
 *                        $prepend=0
 *                        $sort=0
 *                        $let_op=0
 *                        $open_bracket=(
 *                        $close_bracket=)
 *                        $maxargs=16
 *
 *  GiNaC Copyright (C) 1999-2003 Johannes Gutenberg University Mainz, Germany
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __GINAC_EXPRSEQ_H__
#define __GINAC_EXPRSEQ_H__

#include <vector>

// CINT needs <algorithm> to work properly with <vector> and <list> 
#include <algorithm>

#include "basic.h"
#include "ex.h"

namespace GiNaC {


typedef std::vector<ex> exvector;

class exprseq : public basic
{
	GINAC_DECLARE_REGISTERED_CLASS(exprseq, basic)

public:
	exprseq(exvector const & s, bool discardable = false);
	exprseq(exvector * vp); // vp will be deleted
	explicit exprseq(const ex & param1);
	explicit exprseq(const ex & param1, const ex & param2);
	explicit exprseq(const ex & param1, const ex & param2, const ex & param3);
	explicit exprseq(const ex & param1, const ex & param2, const ex & param3, const ex & param4);
	explicit exprseq(const ex & param1, const ex & param2, const ex & param3, const ex & param4, const ex & param5);
	explicit exprseq(const ex & param1, const ex & param2, const ex & param3, const ex & param4, const ex & param5, const ex & param6);
	explicit exprseq(const ex & param1, const ex & param2, const ex & param3, const ex & param4, const ex & param5, const ex & param6, const ex & param7);
	explicit exprseq(const ex & param1, const ex & param2, const ex & param3, const ex & param4, const ex & param5, const ex & param6, const ex & param7, const ex & param8);
	explicit exprseq(const ex & param1, const ex & param2, const ex & param3, const ex & param4, const ex & param5, const ex & param6, const ex & param7, const ex & param8, const ex & param9);
	explicit exprseq(const ex & param1, const ex & param2, const ex & param3, const ex & param4, const ex & param5, const ex & param6, const ex & param7, const ex & param8, const ex & param9, const ex & param10);
	explicit exprseq(const ex & param1, const ex & param2, const ex & param3, const ex & param4, const ex & param5, const ex & param6, const ex & param7, const ex & param8, const ex & param9, const ex & param10, const ex & param11);
	explicit exprseq(const ex & param1, const ex & param2, const ex & param3, const ex & param4, const ex & param5, const ex & param6, const ex & param7, const ex & param8, const ex & param9, const ex & param10, const ex & param11, const ex & param12);
	explicit exprseq(const ex & param1, const ex & param2, const ex & param3, const ex & param4, const ex & param5, const ex & param6, const ex & param7, const ex & param8, const ex & param9, const ex & param10, const ex & param11, const ex & param12, const ex & param13);
	explicit exprseq(const ex & param1, const ex & param2, const ex & param3, const ex & param4, const ex & param5, const ex & param6, const ex & param7, const ex & param8, const ex & param9, const ex & param10, const ex & param11, const ex & param12, const ex & param13, const ex & param14);
	explicit exprseq(const ex & param1, const ex & param2, const ex & param3, const ex & param4, const ex & param5, const ex & param6, const ex & param7, const ex & param8, const ex & param9, const ex & param10, const ex & param11, const ex & param12, const ex & param13, const ex & param14, const ex & param15);
	explicit exprseq(const ex & param1, const ex & param2, const ex & param3, const ex & param4, const ex & param5, const ex & param6, const ex & param7, const ex & param8, const ex & param9, const ex & param10, const ex & param11, const ex & param12, const ex & param13, const ex & param14, const ex & param15, const ex & param16);


public:
	void print(const print_context & c, unsigned level = 0) const;
	unsigned precedence(void) const {return 10;}
	bool info(unsigned inf) const;
	unsigned nops() const;
	ex & let_op(int i);
	ex map(map_function & f) const;
	ex eval(int level=0) const;
	ex subs(const lst & ls, const lst & lr, bool no_pattern = false) const;
protected:
	bool is_equal_same_type(const basic & other) const;

	// new virtual functions which can be overridden by derived classes
public:
	virtual exprseq & append(const ex & b);
	virtual exprseq & remove_last(void);
    // no prepend possible for exprseq
    // no sort possible for exprseq
protected:
	virtual void printseq(const print_context & c, char openbracket, char delim,
	                      char closebracket, unsigned this_precedence,
	                      unsigned upper_precedence = 0) const;
	virtual ex thisexprseq(exvector const & v) const;
	virtual ex thisexprseq(exvector * vp) const;

protected:
	bool is_canonical() const;
	exvector evalchildren(int level) const;
	exvector * subschildren(const lst & ls, const lst & lr, bool no_pattern = false) const;

protected:
	exvector seq;
};

// utility functions

/** Specialization of is_exactly_a<exprseq>(obj) for exprseq objects. */
template<> inline bool is_exactly_a<exprseq>(const basic & obj)
{
	return obj.tinfo()==TINFO_exprseq;
}

} // namespace GiNaC

#endif // ndef __GINAC_EXPRSEQ_H__

