/** @file exprseq.cpp
 *
 *  Implementation of GiNaC's exprseq. */

/*
 *  This file was generated automatically by container.pl.
 *  Please do not modify it directly, edit the perl script instead!
 *  container.pl options: $CONTAINER=exprseq
 *                        $STLHEADER=vector
 *                        $reserve=1
 *                        $prepend=0
 *                        $let_op=0
 *                        $open_bracket=(
 *                        $close_bracket=)
 *                        $maxargs=16
 *
 *  GiNaC Copyright (C) 1999-2003 Johannes Gutenberg University Mainz, Germany
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <iostream>
#include <stdexcept>

#include "exprseq.h"
#include "ex.h"
#include "print.h"
#include "archive.h"

namespace GiNaC {

GINAC_IMPLEMENT_REGISTERED_CLASS(exprseq, basic)

#define RESERVE(s,size) (s).reserve(size)

//////////
// default ctor, dtor, copy ctor, assignment operator and helpers
//////////

// public

exprseq::exprseq() : basic(TINFO_exprseq) {}

// protected

void exprseq::copy(exprseq const & other)
{
	inherited::copy(other);
	seq=other.seq;
}

void exprseq::destroy(bool call_parent)
{
	seq.clear();
	if (call_parent) inherited::destroy(call_parent);
}

//////////
// other ctors
//////////

// public

exprseq::exprseq(exvector const & s, bool discardable) :  basic(TINFO_exprseq)
{
	if (discardable) {
		seq.swap(const_cast<exvector &>(s));
	} else {
		seq=s;
	}
}

exprseq::exprseq(exvector * vp) : basic(TINFO_exprseq)
{
	GINAC_ASSERT(vp!=0);
	seq.swap(*vp);
	delete vp;
}

exprseq::exprseq(const ex & param1) : basic(TINFO_exprseq)
{
	RESERVE(seq,1);
	seq.push_back(param1);
}
exprseq::exprseq(const ex & param1, const ex & param2) : basic(TINFO_exprseq)
{
	RESERVE(seq,2);
	seq.push_back(param1);
	seq.push_back(param2);
}
exprseq::exprseq(const ex & param1, const ex & param2, const ex & param3) : basic(TINFO_exprseq)
{
	RESERVE(seq,3);
	seq.push_back(param1);
	seq.push_back(param2);
	seq.push_back(param3);
}
exprseq::exprseq(const ex & param1, const ex & param2, const ex & param3, const ex & param4) : basic(TINFO_exprseq)
{
	RESERVE(seq,4);
	seq.push_back(param1);
	seq.push_back(param2);
	seq.push_back(param3);
	seq.push_back(param4);
}
exprseq::exprseq(const ex & param1, const ex & param2, const ex & param3, const ex & param4, const ex & param5) : basic(TINFO_exprseq)
{
	RESERVE(seq,5);
	seq.push_back(param1);
	seq.push_back(param2);
	seq.push_back(param3);
	seq.push_back(param4);
	seq.push_back(param5);
}
exprseq::exprseq(const ex & param1, const ex & param2, const ex & param3, const ex & param4, const ex & param5, const ex & param6) : basic(TINFO_exprseq)
{
	RESERVE(seq,6);
	seq.push_back(param1);
	seq.push_back(param2);
	seq.push_back(param3);
	seq.push_back(param4);
	seq.push_back(param5);
	seq.push_back(param6);
}
exprseq::exprseq(const ex & param1, const ex & param2, const ex & param3, const ex & param4, const ex & param5, const ex & param6, const ex & param7) : basic(TINFO_exprseq)
{
	RESERVE(seq,7);
	seq.push_back(param1);
	seq.push_back(param2);
	seq.push_back(param3);
	seq.push_back(param4);
	seq.push_back(param5);
	seq.push_back(param6);
	seq.push_back(param7);
}
exprseq::exprseq(const ex & param1, const ex & param2, const ex & param3, const ex & param4, const ex & param5, const ex & param6, const ex & param7, const ex & param8) : basic(TINFO_exprseq)
{
	RESERVE(seq,8);
	seq.push_back(param1);
	seq.push_back(param2);
	seq.push_back(param3);
	seq.push_back(param4);
	seq.push_back(param5);
	seq.push_back(param6);
	seq.push_back(param7);
	seq.push_back(param8);
}
exprseq::exprseq(const ex & param1, const ex & param2, const ex & param3, const ex & param4, const ex & param5, const ex & param6, const ex & param7, const ex & param8, const ex & param9) : basic(TINFO_exprseq)
{
	RESERVE(seq,9);
	seq.push_back(param1);
	seq.push_back(param2);
	seq.push_back(param3);
	seq.push_back(param4);
	seq.push_back(param5);
	seq.push_back(param6);
	seq.push_back(param7);
	seq.push_back(param8);
	seq.push_back(param9);
}
exprseq::exprseq(const ex & param1, const ex & param2, const ex & param3, const ex & param4, const ex & param5, const ex & param6, const ex & param7, const ex & param8, const ex & param9, const ex & param10) : basic(TINFO_exprseq)
{
	RESERVE(seq,10);
	seq.push_back(param1);
	seq.push_back(param2);
	seq.push_back(param3);
	seq.push_back(param4);
	seq.push_back(param5);
	seq.push_back(param6);
	seq.push_back(param7);
	seq.push_back(param8);
	seq.push_back(param9);
	seq.push_back(param10);
}
exprseq::exprseq(const ex & param1, const ex & param2, const ex & param3, const ex & param4, const ex & param5, const ex & param6, const ex & param7, const ex & param8, const ex & param9, const ex & param10, const ex & param11) : basic(TINFO_exprseq)
{
	RESERVE(seq,11);
	seq.push_back(param1);
	seq.push_back(param2);
	seq.push_back(param3);
	seq.push_back(param4);
	seq.push_back(param5);
	seq.push_back(param6);
	seq.push_back(param7);
	seq.push_back(param8);
	seq.push_back(param9);
	seq.push_back(param10);
	seq.push_back(param11);
}
exprseq::exprseq(const ex & param1, const ex & param2, const ex & param3, const ex & param4, const ex & param5, const ex & param6, const ex & param7, const ex & param8, const ex & param9, const ex & param10, const ex & param11, const ex & param12) : basic(TINFO_exprseq)
{
	RESERVE(seq,12);
	seq.push_back(param1);
	seq.push_back(param2);
	seq.push_back(param3);
	seq.push_back(param4);
	seq.push_back(param5);
	seq.push_back(param6);
	seq.push_back(param7);
	seq.push_back(param8);
	seq.push_back(param9);
	seq.push_back(param10);
	seq.push_back(param11);
	seq.push_back(param12);
}
exprseq::exprseq(const ex & param1, const ex & param2, const ex & param3, const ex & param4, const ex & param5, const ex & param6, const ex & param7, const ex & param8, const ex & param9, const ex & param10, const ex & param11, const ex & param12, const ex & param13) : basic(TINFO_exprseq)
{
	RESERVE(seq,13);
	seq.push_back(param1);
	seq.push_back(param2);
	seq.push_back(param3);
	seq.push_back(param4);
	seq.push_back(param5);
	seq.push_back(param6);
	seq.push_back(param7);
	seq.push_back(param8);
	seq.push_back(param9);
	seq.push_back(param10);
	seq.push_back(param11);
	seq.push_back(param12);
	seq.push_back(param13);
}
exprseq::exprseq(const ex & param1, const ex & param2, const ex & param3, const ex & param4, const ex & param5, const ex & param6, const ex & param7, const ex & param8, const ex & param9, const ex & param10, const ex & param11, const ex & param12, const ex & param13, const ex & param14) : basic(TINFO_exprseq)
{
	RESERVE(seq,14);
	seq.push_back(param1);
	seq.push_back(param2);
	seq.push_back(param3);
	seq.push_back(param4);
	seq.push_back(param5);
	seq.push_back(param6);
	seq.push_back(param7);
	seq.push_back(param8);
	seq.push_back(param9);
	seq.push_back(param10);
	seq.push_back(param11);
	seq.push_back(param12);
	seq.push_back(param13);
	seq.push_back(param14);
}
exprseq::exprseq(const ex & param1, const ex & param2, const ex & param3, const ex & param4, const ex & param5, const ex & param6, const ex & param7, const ex & param8, const ex & param9, const ex & param10, const ex & param11, const ex & param12, const ex & param13, const ex & param14, const ex & param15) : basic(TINFO_exprseq)
{
	RESERVE(seq,15);
	seq.push_back(param1);
	seq.push_back(param2);
	seq.push_back(param3);
	seq.push_back(param4);
	seq.push_back(param5);
	seq.push_back(param6);
	seq.push_back(param7);
	seq.push_back(param8);
	seq.push_back(param9);
	seq.push_back(param10);
	seq.push_back(param11);
	seq.push_back(param12);
	seq.push_back(param13);
	seq.push_back(param14);
	seq.push_back(param15);
}
exprseq::exprseq(const ex & param1, const ex & param2, const ex & param3, const ex & param4, const ex & param5, const ex & param6, const ex & param7, const ex & param8, const ex & param9, const ex & param10, const ex & param11, const ex & param12, const ex & param13, const ex & param14, const ex & param15, const ex & param16) : basic(TINFO_exprseq)
{
	RESERVE(seq,16);
	seq.push_back(param1);
	seq.push_back(param2);
	seq.push_back(param3);
	seq.push_back(param4);
	seq.push_back(param5);
	seq.push_back(param6);
	seq.push_back(param7);
	seq.push_back(param8);
	seq.push_back(param9);
	seq.push_back(param10);
	seq.push_back(param11);
	seq.push_back(param12);
	seq.push_back(param13);
	seq.push_back(param14);
	seq.push_back(param15);
	seq.push_back(param16);
}


//////////
// archiving
//////////

/** Construct object from archive_node. */
exprseq::exprseq(const archive_node &n, const lst &sym_lst) : inherited(n, sym_lst)
{
	for (unsigned int i=0; true; i++) {
		ex e;
		if (n.find_ex("seq", e, sym_lst, i))
			seq.push_back(e);
		else
			break;
	}
}

/** Unarchive the object. */
ex exprseq::unarchive(const archive_node &n, const lst &sym_lst)
{
	return (new exprseq(n, sym_lst))->setflag(status_flags::dynallocated);
}

/** Archive the object. */
void exprseq::archive(archive_node &n) const
{
	inherited::archive(n);
	exvector::const_iterator i = seq.begin(), end = seq.end();
	while (i != end) {
		n.add_ex("seq", *i);
		++i;
	}
}

//////////
// functions overriding virtual functions from base classes
//////////

// public

void exprseq::print(const print_context & c, unsigned level) const
{
	if (is_a<print_tree>(c)) {

		c.s << std::string(level, ' ') << class_name()
		    << std::hex << ", hash=0x" << hashvalue << ", flags=0x" << flags << std::dec
		    << ", nops=" << nops()
		    << std::endl;
		unsigned delta_indent = static_cast<const print_tree &>(c).delta_indent;
		exvector::const_iterator i = seq.begin(), end = seq.end();
		while (i != end) {
			i->print(c, level + delta_indent);
			++i;
		}
		c.s << std::string(level + delta_indent,' ') << "=====" << std::endl;
	} else if (is_a<print_python>(c)) {
		printseq(c, '[', ',', ']', precedence(), precedence()+1);
	} else if (is_a<print_python_repr>(c)) {
		c.s << class_name ();
		printseq(c, '(', ',', ')', precedence(), precedence()+1);
	} else {
		// always print brackets around seq, ignore upper_precedence
		printseq(c, '(', ',', ')', precedence(), precedence()+1);
	}
}

// exprseq::info() will be implemented by user elsewhere";

unsigned exprseq::nops() const
{
	return seq.size();
}

// exprseq::let_op() will be implemented by user elsewhere

ex exprseq::map(map_function & f) const
{
	// This implementation is here because basic::map() uses let_op()
	// which is not defined for all containers
	exvector s;
	RESERVE(s,seq.size());
	exvector::const_iterator i = seq.begin(), end = seq.end();
	while (i != end) {
		s.push_back(f(*i));
		++i;
	}

	return thisexprseq(s);
}

ex exprseq::eval(int level) const
{
	if (level==1) {
		return this->hold();
	}
	return thisexprseq(evalchildren(level));
}

ex exprseq::subs(const lst & ls, const lst & lr, bool no_pattern) const
{
	exvector *vp = subschildren(ls, lr, no_pattern);
	if (vp)
		return ex_to<basic>(thisexprseq(vp)).basic::subs(ls, lr, no_pattern);
	else
		return basic::subs(ls, lr, no_pattern);
}

// protected

int exprseq::compare_same_type(const basic & other) const
{
	GINAC_ASSERT(is_a<exprseq>(other));
	exprseq const & o = static_cast<const exprseq &>(other);

	exvector::const_iterator it1 = seq.begin(), it1end = seq.end(),
	                        it2 = o.seq.begin(), it2end = o.seq.end();

	while (it1 != it1end && it2 != it2end) {
		int cmpval = it1->compare(*it2);
		if (cmpval)
			return cmpval;
		++it1; ++it2;
	}

	return (it1 == it1end) ? (it2 == it2end ? 0 : -1) : 1;
}

bool exprseq::is_equal_same_type(const basic & other) const
{
	GINAC_ASSERT(is_a<exprseq>(other));
	exprseq const &o = static_cast<const exprseq &>(other);

	if (seq.size() != o.seq.size())
		return false;

	exvector::const_iterator it1 = seq.begin(), it1end = seq.end(),
	                        it2 = o.seq.begin();

	while (it1 != it1end) {
		if (!it1->is_equal(*it2))
			return false;
		++it1; ++it2;
	}

	return true;
}

//////////
// new virtual functions which can be overridden by derived classes
//////////

// public

exprseq & exprseq::append(const ex & b)
{
	ensure_if_modifiable();
	seq.push_back(b);
	return *this;
}

exprseq & exprseq::remove_last(void)
{
	ensure_if_modifiable();
	seq.pop_back();
	return *this;
}





// protected

void exprseq::printseq(const print_context & c, char openbracket, char delim,
                            char closebracket, unsigned this_precedence,
                            unsigned upper_precedence) const
{
	if (this_precedence <= upper_precedence)
		c.s << openbracket;

	if (!seq.empty()) {
		exvector::const_iterator it = seq.begin(), itend = seq.end();
		--itend;
		while (it != itend) {
			it->print(c, this_precedence);
			c.s << delim;
			++it;
		}
		it->print(c, this_precedence);
	}

	if (this_precedence <= upper_precedence)
		c.s << closebracket;
}

ex exprseq::thisexprseq(exvector const & v) const
{
	return exprseq(v);
}

ex exprseq::thisexprseq(exvector * vp) const
{
	return exprseq(vp);
}

//////////
// non-virtual functions in this class
//////////

// public

// none

// protected

bool exprseq::is_canonical() const
{
	if (seq.size()<=1) { return 1; }

	exvector::const_iterator it = seq.begin(), itend = seq.end();
	exvector::const_iterator it_last=it;
	for (++it; it!=itend; it_last=it, ++it) {
		if (it_last->compare(*it)>0) {
			if (it_last->compare(*it)>0) {
				std::cout << *it_last << ">" << *it << "\n";
				return 0;
			}
		}
	}
	return 1;
}


exvector exprseq::evalchildren(int level) const
{
	exvector s;
	RESERVE(s,seq.size());

	if (level==1) {
		return seq;
	}
	if (level == -max_recursion_level) {
		throw(std::runtime_error("max recursion level reached"));
	}
	--level;
	exvector::const_iterator it = seq.begin(), itend = seq.end();
	while (it != itend) {
		s.push_back(it->eval(level));
		++it;
	}
	return s;
}

exvector * exprseq::subschildren(const lst & ls, const lst & lr, bool no_pattern) const
{
	// returns a NULL pointer if nothing had to be substituted
	// returns a pointer to a newly created epvector otherwise
	// (which has to be deleted somewhere else)

	exvector::const_iterator cit = seq.begin(), end = seq.end();
	while (cit != end) {
		const ex & subsed_ex = cit->subs(ls, lr, no_pattern);
		if (!are_ex_trivially_equal(*cit, subsed_ex)) {

			// something changed, copy seq, subs and return it
			exvector *s=new exvector;
			RESERVE(*s, seq.size());

			// copy parts of seq which are known not to have changed
			exvector::const_iterator cit2 = seq.begin();
			while (cit2 != cit) {
				s->push_back(*cit2);
				++cit2;
			}

			// copy first changed element
			s->push_back(subsed_ex);
			++cit2;

			// copy rest
			while (cit2 != end) {
				s->push_back(cit2->subs(ls, lr, no_pattern));
				++cit2;
			}
			return s;
		}
		++cit;
	}
	
	return 0; // nothing has changed
}

} // namespace GiNaC

