/** @file function.h
 *
 *  Interface to abstract class function (new function concept). */

/*
 *  This file was generated automatically by function.pl.
 *  Please do not modify it directly, edit the perl script instead!
 *  function.pl options: $maxargs=10
 *
 *  GiNaC Copyright (C) 1999-2000 Johannes Gutenberg University Mainz, Germany
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __GINAC_FUNCTION_H__
#define __GINAC_FUNCTION_H__

#include <string>
#include <vector>

#ifdef __CINT__
// CINT needs <algorithm> to work properly with <vector> 
#include <algorithm>
#endif // def __CINT__

#include "exprseq.h"

#ifndef NO_NAMESPACE_GINAC

// the following lines have been generated for max. 10 parameters
#define DECLARE_FUNCTION_1P(NAME) \
extern const unsigned function_index_##NAME; \
inline GiNaC::function NAME(const GiNaC::ex & p1) { \
    return GiNaC::function(function_index_##NAME, p1); \
}

#define DECLARE_FUNCTION_2P(NAME) \
extern const unsigned function_index_##NAME; \
inline GiNaC::function NAME(const GiNaC::ex & p1, const GiNaC::ex & p2) { \
    return GiNaC::function(function_index_##NAME, p1, p2); \
}

#define DECLARE_FUNCTION_3P(NAME) \
extern const unsigned function_index_##NAME; \
inline GiNaC::function NAME(const GiNaC::ex & p1, const GiNaC::ex & p2, const GiNaC::ex & p3) { \
    return GiNaC::function(function_index_##NAME, p1, p2, p3); \
}

#define DECLARE_FUNCTION_4P(NAME) \
extern const unsigned function_index_##NAME; \
inline GiNaC::function NAME(const GiNaC::ex & p1, const GiNaC::ex & p2, const GiNaC::ex & p3, const GiNaC::ex & p4) { \
    return GiNaC::function(function_index_##NAME, p1, p2, p3, p4); \
}

#define DECLARE_FUNCTION_5P(NAME) \
extern const unsigned function_index_##NAME; \
inline GiNaC::function NAME(const GiNaC::ex & p1, const GiNaC::ex & p2, const GiNaC::ex & p3, const GiNaC::ex & p4, const GiNaC::ex & p5) { \
    return GiNaC::function(function_index_##NAME, p1, p2, p3, p4, p5); \
}

#define DECLARE_FUNCTION_6P(NAME) \
extern const unsigned function_index_##NAME; \
inline GiNaC::function NAME(const GiNaC::ex & p1, const GiNaC::ex & p2, const GiNaC::ex & p3, const GiNaC::ex & p4, const GiNaC::ex & p5, const GiNaC::ex & p6) { \
    return GiNaC::function(function_index_##NAME, p1, p2, p3, p4, p5, p6); \
}

#define DECLARE_FUNCTION_7P(NAME) \
extern const unsigned function_index_##NAME; \
inline GiNaC::function NAME(const GiNaC::ex & p1, const GiNaC::ex & p2, const GiNaC::ex & p3, const GiNaC::ex & p4, const GiNaC::ex & p5, const GiNaC::ex & p6, const GiNaC::ex & p7) { \
    return GiNaC::function(function_index_##NAME, p1, p2, p3, p4, p5, p6, p7); \
}

#define DECLARE_FUNCTION_8P(NAME) \
extern const unsigned function_index_##NAME; \
inline GiNaC::function NAME(const GiNaC::ex & p1, const GiNaC::ex & p2, const GiNaC::ex & p3, const GiNaC::ex & p4, const GiNaC::ex & p5, const GiNaC::ex & p6, const GiNaC::ex & p7, const GiNaC::ex & p8) { \
    return GiNaC::function(function_index_##NAME, p1, p2, p3, p4, p5, p6, p7, p8); \
}

#define DECLARE_FUNCTION_9P(NAME) \
extern const unsigned function_index_##NAME; \
inline GiNaC::function NAME(const GiNaC::ex & p1, const GiNaC::ex & p2, const GiNaC::ex & p3, const GiNaC::ex & p4, const GiNaC::ex & p5, const GiNaC::ex & p6, const GiNaC::ex & p7, const GiNaC::ex & p8, const GiNaC::ex & p9) { \
    return GiNaC::function(function_index_##NAME, p1, p2, p3, p4, p5, p6, p7, p8, p9); \
}

#define DECLARE_FUNCTION_10P(NAME) \
extern const unsigned function_index_##NAME; \
inline GiNaC::function NAME(const GiNaC::ex & p1, const GiNaC::ex & p2, const GiNaC::ex & p3, const GiNaC::ex & p4, const GiNaC::ex & p5, const GiNaC::ex & p6, const GiNaC::ex & p7, const GiNaC::ex & p8, const GiNaC::ex & p9, const GiNaC::ex & p10) { \
    return GiNaC::function(function_index_##NAME, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10); \
}


// end of generated lines

#else // ndef NO_NAMESPACE_GINAC

// the following lines have been generated for max. 10 parameters
#define DECLARE_FUNCTION_1P(NAME) \
extern const unsigned function_index_##NAME; \
inline function NAME(const ex & p1) { \
    return function(function_index_##NAME, p1); \
}

#define DECLARE_FUNCTION_2P(NAME) \
extern const unsigned function_index_##NAME; \
inline function NAME(const ex & p1, const ex & p2) { \
    return function(function_index_##NAME, p1, p2); \
}

#define DECLARE_FUNCTION_3P(NAME) \
extern const unsigned function_index_##NAME; \
inline function NAME(const ex & p1, const ex & p2, const ex & p3) { \
    return function(function_index_##NAME, p1, p2, p3); \
}

#define DECLARE_FUNCTION_4P(NAME) \
extern const unsigned function_index_##NAME; \
inline function NAME(const ex & p1, const ex & p2, const ex & p3, const ex & p4) { \
    return function(function_index_##NAME, p1, p2, p3, p4); \
}

#define DECLARE_FUNCTION_5P(NAME) \
extern const unsigned function_index_##NAME; \
inline function NAME(const ex & p1, const ex & p2, const ex & p3, const ex & p4, const ex & p5) { \
    return function(function_index_##NAME, p1, p2, p3, p4, p5); \
}

#define DECLARE_FUNCTION_6P(NAME) \
extern const unsigned function_index_##NAME; \
inline function NAME(const ex & p1, const ex & p2, const ex & p3, const ex & p4, const ex & p5, const ex & p6) { \
    return function(function_index_##NAME, p1, p2, p3, p4, p5, p6); \
}

#define DECLARE_FUNCTION_7P(NAME) \
extern const unsigned function_index_##NAME; \
inline function NAME(const ex & p1, const ex & p2, const ex & p3, const ex & p4, const ex & p5, const ex & p6, const ex & p7) { \
    return function(function_index_##NAME, p1, p2, p3, p4, p5, p6, p7); \
}

#define DECLARE_FUNCTION_8P(NAME) \
extern const unsigned function_index_##NAME; \
inline function NAME(const ex & p1, const ex & p2, const ex & p3, const ex & p4, const ex & p5, const ex & p6, const ex & p7, const ex & p8) { \
    return function(function_index_##NAME, p1, p2, p3, p4, p5, p6, p7, p8); \
}

#define DECLARE_FUNCTION_9P(NAME) \
extern const unsigned function_index_##NAME; \
inline function NAME(const ex & p1, const ex & p2, const ex & p3, const ex & p4, const ex & p5, const ex & p6, const ex & p7, const ex & p8, const ex & p9) { \
    return function(function_index_##NAME, p1, p2, p3, p4, p5, p6, p7, p8, p9); \
}

#define DECLARE_FUNCTION_10P(NAME) \
extern const unsigned function_index_##NAME; \
inline function NAME(const ex & p1, const ex & p2, const ex & p3, const ex & p4, const ex & p5, const ex & p6, const ex & p7, const ex & p8, const ex & p9, const ex & p10) { \
    return function(function_index_##NAME, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10); \
}


// end of generated lines

#endif // ndef NO_NAMESPACE_GINAC

#ifndef NO_NAMESPACE_GINAC

#define REGISTER_FUNCTION(NAME,E,EF,D,S) \
const unsigned function_index_##NAME=GiNaC::function::register_new(#NAME,E,EF,D,S);

#else // ndef NO_NAMESPACE_GINAC

#define REGISTER_FUNCTION(NAME,E,EF,D,S) \
const unsigned function_index_##NAME=function::register_new(#NAME,E,EF,D,S);

#endif // ndef NO_NAMESPACE_GINAC

#define BEGIN_TYPECHECK \
bool automatic_typecheck=true;

#define TYPECHECK(VAR,TYPE) \
if (!is_ex_exactly_of_type(VAR,TYPE)) { \
    automatic_typecheck=false; \
} else

#ifndef NO_NAMESPACE_GINAC

#define TYPECHECK_INTEGER(VAR) \
if (!(VAR).info(GiNaC::info_flags::integer)) { \
    automatic_typecheck=false; \
} else

#else // ndef NO_NAMESPACE_GINAC

#define TYPECHECK_INTEGER(VAR) \
if (!(VAR).info(info_flags::integer)) { \
    automatic_typecheck=false; \
} else

#endif // ndef NO_NAMESPACE_GINAC

#define END_TYPECHECK(RV) \
{} \
if (!automatic_typecheck) { \
    return RV.hold(); \
}

#ifndef NO_NAMESPACE_GINAC
namespace GiNaC {
#endif // ndef NO_NAMESPACE_GINAC

class function;

typedef ex (* eval_funcp)();
typedef ex (* evalf_funcp)();
typedef ex (* derivative_funcp)();
typedef ex (* series_funcp)();

// the following lines have been generated for max. 10 parameters
typedef ex (* eval_funcp_1)(const ex &);
typedef ex (* eval_funcp_2)(const ex &, const ex &);
typedef ex (* eval_funcp_3)(const ex &, const ex &, const ex &);
typedef ex (* eval_funcp_4)(const ex &, const ex &, const ex &, const ex &);
typedef ex (* eval_funcp_5)(const ex &, const ex &, const ex &, const ex &, const ex &);
typedef ex (* eval_funcp_6)(const ex &, const ex &, const ex &, const ex &, const ex &, const ex &);
typedef ex (* eval_funcp_7)(const ex &, const ex &, const ex &, const ex &, const ex &, const ex &, const ex &);
typedef ex (* eval_funcp_8)(const ex &, const ex &, const ex &, const ex &, const ex &, const ex &, const ex &, const ex &);
typedef ex (* eval_funcp_9)(const ex &, const ex &, const ex &, const ex &, const ex &, const ex &, const ex &, const ex &, const ex &);
typedef ex (* eval_funcp_10)(const ex &, const ex &, const ex &, const ex &, const ex &, const ex &, const ex &, const ex &, const ex &, const ex &);

typedef ex (* evalf_funcp_1)(const ex &);
typedef ex (* evalf_funcp_2)(const ex &, const ex &);
typedef ex (* evalf_funcp_3)(const ex &, const ex &, const ex &);
typedef ex (* evalf_funcp_4)(const ex &, const ex &, const ex &, const ex &);
typedef ex (* evalf_funcp_5)(const ex &, const ex &, const ex &, const ex &, const ex &);
typedef ex (* evalf_funcp_6)(const ex &, const ex &, const ex &, const ex &, const ex &, const ex &);
typedef ex (* evalf_funcp_7)(const ex &, const ex &, const ex &, const ex &, const ex &, const ex &, const ex &);
typedef ex (* evalf_funcp_8)(const ex &, const ex &, const ex &, const ex &, const ex &, const ex &, const ex &, const ex &);
typedef ex (* evalf_funcp_9)(const ex &, const ex &, const ex &, const ex &, const ex &, const ex &, const ex &, const ex &, const ex &);
typedef ex (* evalf_funcp_10)(const ex &, const ex &, const ex &, const ex &, const ex &, const ex &, const ex &, const ex &, const ex &, const ex &);

typedef ex (* derivative_funcp_1)(const ex &, unsigned);
typedef ex (* derivative_funcp_2)(const ex &, const ex &, unsigned);
typedef ex (* derivative_funcp_3)(const ex &, const ex &, const ex &, unsigned);
typedef ex (* derivative_funcp_4)(const ex &, const ex &, const ex &, const ex &, unsigned);
typedef ex (* derivative_funcp_5)(const ex &, const ex &, const ex &, const ex &, const ex &, unsigned);
typedef ex (* derivative_funcp_6)(const ex &, const ex &, const ex &, const ex &, const ex &, const ex &, unsigned);
typedef ex (* derivative_funcp_7)(const ex &, const ex &, const ex &, const ex &, const ex &, const ex &, const ex &, unsigned);
typedef ex (* derivative_funcp_8)(const ex &, const ex &, const ex &, const ex &, const ex &, const ex &, const ex &, const ex &, unsigned);
typedef ex (* derivative_funcp_9)(const ex &, const ex &, const ex &, const ex &, const ex &, const ex &, const ex &, const ex &, const ex &, unsigned);
typedef ex (* derivative_funcp_10)(const ex &, const ex &, const ex &, const ex &, const ex &, const ex &, const ex &, const ex &, const ex &, const ex &, unsigned);

typedef ex (* series_funcp_1)(const ex &, const symbol &, const ex &, int);
typedef ex (* series_funcp_2)(const ex &, const ex &, const symbol &, const ex &, int);
typedef ex (* series_funcp_3)(const ex &, const ex &, const ex &, const symbol &, const ex &, int);
typedef ex (* series_funcp_4)(const ex &, const ex &, const ex &, const ex &, const symbol &, const ex &, int);
typedef ex (* series_funcp_5)(const ex &, const ex &, const ex &, const ex &, const ex &, const symbol &, const ex &, int);
typedef ex (* series_funcp_6)(const ex &, const ex &, const ex &, const ex &, const ex &, const ex &, const symbol &, const ex &, int);
typedef ex (* series_funcp_7)(const ex &, const ex &, const ex &, const ex &, const ex &, const ex &, const ex &, const symbol &, const ex &, int);
typedef ex (* series_funcp_8)(const ex &, const ex &, const ex &, const ex &, const ex &, const ex &, const ex &, const ex &, const symbol &, const ex &, int);
typedef ex (* series_funcp_9)(const ex &, const ex &, const ex &, const ex &, const ex &, const ex &, const ex &, const ex &, const ex &, const symbol &, const ex &, int);
typedef ex (* series_funcp_10)(const ex &, const ex &, const ex &, const ex &, const ex &, const ex &, const ex &, const ex &, const ex &, const ex &, const symbol &, const ex &, int);

// end of generated lines

struct registered_function_info {
    const char * name;
    unsigned nparams;
    unsigned options;
    eval_funcp e;
    evalf_funcp ef;
    derivative_funcp d;
    series_funcp s;
};

/** The class function is used to implement builtin functions like sin, cos...
    and user defined functions */
class function : public exprseq
{
    GINAC_DECLARE_REGISTERED_CLASS(function, exprseq)

    // CINT has a linking problem
    friend void ginsh_get_ginac_functions(void);

// member functions

    // default constructor, destructor, copy constructor assignment operator and helpers
public:
    function();
    ~function();
    function(const function & other);
    const function & operator=(const function & other);
protected:
    void copy(const function & other);
    void destroy(bool call_parent);

    // other constructors
public:
    function(unsigned ser);
    // the following lines have been generated for max. 10 parameters
    function(unsigned ser, const ex & param1);
    function(unsigned ser, const ex & param1, const ex & param2);
    function(unsigned ser, const ex & param1, const ex & param2, const ex & param3);
    function(unsigned ser, const ex & param1, const ex & param2, const ex & param3, const ex & param4);
    function(unsigned ser, const ex & param1, const ex & param2, const ex & param3, const ex & param4, const ex & param5);
    function(unsigned ser, const ex & param1, const ex & param2, const ex & param3, const ex & param4, const ex & param5, const ex & param6);
    function(unsigned ser, const ex & param1, const ex & param2, const ex & param3, const ex & param4, const ex & param5, const ex & param6, const ex & param7);
    function(unsigned ser, const ex & param1, const ex & param2, const ex & param3, const ex & param4, const ex & param5, const ex & param6, const ex & param7, const ex & param8);
    function(unsigned ser, const ex & param1, const ex & param2, const ex & param3, const ex & param4, const ex & param5, const ex & param6, const ex & param7, const ex & param8, const ex & param9);
    function(unsigned ser, const ex & param1, const ex & param2, const ex & param3, const ex & param4, const ex & param5, const ex & param6, const ex & param7, const ex & param8, const ex & param9, const ex & param10);

    // end of generated lines
    function(unsigned ser, const exprseq & es);
    function(unsigned ser, const exvector & v, bool discardable=0);
    function(unsigned ser, exvector * vp); // vp will be deleted

    // functions overriding virtual functions from bases classes
public:
    basic * duplicate() const;
    void printraw(ostream & os) const; 
    void print(ostream & os, unsigned upper_precedence=0) const;
    void printtree(ostream & os, unsigned indent) const;
    void printcsrc(ostream & os, unsigned type, unsigned upper_precedence=0) const;
    ex expand(unsigned options=0) const;
    ex eval(int level=0) const;
    ex evalf(int level=0) const;
    ex series(const symbol & s, const ex & point, int order) const;
    ex thisexprseq(const exvector & v) const;
    ex thisexprseq(exvector * vp) const;
protected:
    ex derivative(const symbol & s) const;
    int compare_same_type(const basic & other) const;
    bool is_equal_same_type(const basic & other) const;
    unsigned return_type(void) const;
    unsigned return_type_tinfo(void) const;
    
    // new virtual functions which can be overridden by derived classes
    // none
    
    // non-virtual functions in this class
protected:
    ex pderivative(unsigned diff_param) const; // partial differentiation
    static vector<registered_function_info> & registered_functions(void);
public:
    // the following lines have been generated for max. 10 parameters
    static unsigned register_new(const char * nm, eval_funcp_1 e,
                                 evalf_funcp_1 ef=0, derivative_funcp_1 d=0, series_funcp_1 s=0);
    static unsigned register_new(const char * nm, eval_funcp_2 e,
                                 evalf_funcp_2 ef=0, derivative_funcp_2 d=0, series_funcp_2 s=0);
    static unsigned register_new(const char * nm, eval_funcp_3 e,
                                 evalf_funcp_3 ef=0, derivative_funcp_3 d=0, series_funcp_3 s=0);
    static unsigned register_new(const char * nm, eval_funcp_4 e,
                                 evalf_funcp_4 ef=0, derivative_funcp_4 d=0, series_funcp_4 s=0);
    static unsigned register_new(const char * nm, eval_funcp_5 e,
                                 evalf_funcp_5 ef=0, derivative_funcp_5 d=0, series_funcp_5 s=0);
    static unsigned register_new(const char * nm, eval_funcp_6 e,
                                 evalf_funcp_6 ef=0, derivative_funcp_6 d=0, series_funcp_6 s=0);
    static unsigned register_new(const char * nm, eval_funcp_7 e,
                                 evalf_funcp_7 ef=0, derivative_funcp_7 d=0, series_funcp_7 s=0);
    static unsigned register_new(const char * nm, eval_funcp_8 e,
                                 evalf_funcp_8 ef=0, derivative_funcp_8 d=0, series_funcp_8 s=0);
    static unsigned register_new(const char * nm, eval_funcp_9 e,
                                 evalf_funcp_9 ef=0, derivative_funcp_9 d=0, series_funcp_9 s=0);
    static unsigned register_new(const char * nm, eval_funcp_10 e,
                                 evalf_funcp_10 ef=0, derivative_funcp_10 d=0, series_funcp_10 s=0);

    // end of generated lines
    unsigned getserial(void) const {return serial;}
    
// member variables

protected:
    unsigned serial;
};

// utility macros

#ifndef NO_NAMESPACE_GINAC

#define is_ex_the_function(OBJ, FUNCNAME) \
    (is_ex_exactly_of_type(OBJ, function) && static_cast<GiNaC::function *>(OBJ.bp)->getserial() == function_index_##FUNCNAME)

#else // ndef NO_NAMESPACE_GINAC

#define is_ex_the_function(OBJ, FUNCNAME) \
    (is_ex_exactly_of_type(OBJ, function) && static_cast<function *>(OBJ.bp)->getserial() == function_index_##FUNCNAME)

#endif // ndef NO_NAMESPACE_GINAC

// global constants

extern const function some_function;
extern const type_info & typeid_function;

#ifndef NO_NAMESPACE_GINAC
} // namespace GiNaC
#endif // ndef NO_NAMESPACE_GINAC

#endif // ndef __GINAC_FUNCTION_H__

