/** @file function.cpp
 *
 *  Implementation of class function. */

/*
 *  This file was generated automatically by function.pl.
 *  Please do not modify it directly, edit the perl script instead!
 *  function.pl options: $maxargs=10
 *
 *  GiNaC Copyright (C) 1999-2000 Johannes Gutenberg University Mainz, Germany
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <string>
#include <stdexcept>

#include "function.h"
#include "ex.h"
#include "archive.h"
#include "inifcns.h"
#include "utils.h"
#include "debugmsg.h"

#ifndef NO_NAMESPACE_GINAC
namespace GiNaC {
#endif // ndef NO_NAMESPACE_GINAC

GINAC_IMPLEMENT_REGISTERED_CLASS(function, exprseq)

//////////
// default constructor, destructor, copy constructor assignment operator and helpers
//////////

// public

function::function() : serial(0)
{
    debugmsg("function default constructor",LOGLEVEL_CONSTRUCT);
    tinfo_key = TINFO_function;
}

function::~function()
{
    debugmsg("function destructor",LOGLEVEL_DESTRUCT);
    destroy(0);
}

function::function(const function & other)
{
    debugmsg("function copy constructor",LOGLEVEL_CONSTRUCT);
    copy(other);
}

const function & function::operator=(const function & other)
{
    debugmsg("function operator=",LOGLEVEL_ASSIGNMENT);
    if (this != &other) {
        destroy(1);
        copy(other);
    }
    return *this;
}

// protected

void function::copy(const function & other)
{
    exprseq::copy(other);
    serial=other.serial;
}

void function::destroy(bool call_parent)
{
    if (call_parent) exprseq::destroy(call_parent);
}

//////////
// other constructors
//////////

// public

function::function(unsigned ser) : serial(ser)
{
    debugmsg("function constructor from unsigned",LOGLEVEL_CONSTRUCT);
    tinfo_key = TINFO_function;
}

// the following lines have been generated for max. 10 parameters
function::function(unsigned ser, const ex & param1)
    : exprseq(param1), serial(ser)
{
    debugmsg("function constructor from unsigned,1*ex",LOGLEVEL_CONSTRUCT);
    tinfo_key = TINFO_function;
}
function::function(unsigned ser, const ex & param1, const ex & param2)
    : exprseq(param1, param2), serial(ser)
{
    debugmsg("function constructor from unsigned,2*ex",LOGLEVEL_CONSTRUCT);
    tinfo_key = TINFO_function;
}
function::function(unsigned ser, const ex & param1, const ex & param2, const ex & param3)
    : exprseq(param1, param2, param3), serial(ser)
{
    debugmsg("function constructor from unsigned,3*ex",LOGLEVEL_CONSTRUCT);
    tinfo_key = TINFO_function;
}
function::function(unsigned ser, const ex & param1, const ex & param2, const ex & param3, const ex & param4)
    : exprseq(param1, param2, param3, param4), serial(ser)
{
    debugmsg("function constructor from unsigned,4*ex",LOGLEVEL_CONSTRUCT);
    tinfo_key = TINFO_function;
}
function::function(unsigned ser, const ex & param1, const ex & param2, const ex & param3, const ex & param4, const ex & param5)
    : exprseq(param1, param2, param3, param4, param5), serial(ser)
{
    debugmsg("function constructor from unsigned,5*ex",LOGLEVEL_CONSTRUCT);
    tinfo_key = TINFO_function;
}
function::function(unsigned ser, const ex & param1, const ex & param2, const ex & param3, const ex & param4, const ex & param5, const ex & param6)
    : exprseq(param1, param2, param3, param4, param5, param6), serial(ser)
{
    debugmsg("function constructor from unsigned,6*ex",LOGLEVEL_CONSTRUCT);
    tinfo_key = TINFO_function;
}
function::function(unsigned ser, const ex & param1, const ex & param2, const ex & param3, const ex & param4, const ex & param5, const ex & param6, const ex & param7)
    : exprseq(param1, param2, param3, param4, param5, param6, param7), serial(ser)
{
    debugmsg("function constructor from unsigned,7*ex",LOGLEVEL_CONSTRUCT);
    tinfo_key = TINFO_function;
}
function::function(unsigned ser, const ex & param1, const ex & param2, const ex & param3, const ex & param4, const ex & param5, const ex & param6, const ex & param7, const ex & param8)
    : exprseq(param1, param2, param3, param4, param5, param6, param7, param8), serial(ser)
{
    debugmsg("function constructor from unsigned,8*ex",LOGLEVEL_CONSTRUCT);
    tinfo_key = TINFO_function;
}
function::function(unsigned ser, const ex & param1, const ex & param2, const ex & param3, const ex & param4, const ex & param5, const ex & param6, const ex & param7, const ex & param8, const ex & param9)
    : exprseq(param1, param2, param3, param4, param5, param6, param7, param8, param9), serial(ser)
{
    debugmsg("function constructor from unsigned,9*ex",LOGLEVEL_CONSTRUCT);
    tinfo_key = TINFO_function;
}
function::function(unsigned ser, const ex & param1, const ex & param2, const ex & param3, const ex & param4, const ex & param5, const ex & param6, const ex & param7, const ex & param8, const ex & param9, const ex & param10)
    : exprseq(param1, param2, param3, param4, param5, param6, param7, param8, param9, param10), serial(ser)
{
    debugmsg("function constructor from unsigned,10*ex",LOGLEVEL_CONSTRUCT);
    tinfo_key = TINFO_function;
}

// end of generated lines

function::function(unsigned ser, const exprseq & es) : exprseq(es), serial(ser)
{
    debugmsg("function constructor from unsigned,exprseq",LOGLEVEL_CONSTRUCT);
    tinfo_key = TINFO_function;
}

function::function(unsigned ser, const exvector & v, bool discardable) 
    : exprseq(v,discardable), serial(ser)
{
    debugmsg("function constructor from string,exvector,bool",LOGLEVEL_CONSTRUCT);
    tinfo_key = TINFO_function;
}

function::function(unsigned ser, exvector * vp) 
    : exprseq(vp), serial(ser)
{
    debugmsg("function constructor from unsigned,exvector *",LOGLEVEL_CONSTRUCT);
    tinfo_key = TINFO_function;
}

//////////
// archiving
//////////

/** Construct object from archive_node. */
function::function(const archive_node &n, const lst &sym_lst) : inherited(n, sym_lst)
{
    debugmsg("function constructor from archive_node", LOGLEVEL_CONSTRUCT);

    // Find serial number by function name
    string s;
    if (n.find_string("name", s)) {
        unsigned int ser = 0;
        vector<registered_function_info>::const_iterator i = registered_functions().begin(), iend = registered_functions().end();
        while (i != iend) {
            if (s == i->name) {
                serial = ser;
                return;
            }
            i++; ser++;
        }
        throw (std::runtime_error("unknown function '" + s + "' in archive"));
    } else
        throw (std::runtime_error("unnamed function in archive"));
}

/** Unarchive the object. */
ex function::unarchive(const archive_node &n, const lst &sym_lst)
{
    return (new function(n, sym_lst))->setflag(status_flags::dynallocated);
}

/** Archive the object. */
void function::archive(archive_node &n) const
{
    inherited::archive(n);
    GINAC_ASSERT(serial < registered_functions().size());
    n.add_string("name", registered_functions()[serial].name);
}

//////////
// functions overriding virtual functions from bases classes
//////////

// public

basic * function::duplicate() const
{
    debugmsg("function duplicate",LOGLEVEL_DUPLICATE);
    return new function(*this);
}

void function::printraw(ostream & os) const
{
    debugmsg("function printraw",LOGLEVEL_PRINT);

    GINAC_ASSERT(serial<registered_functions().size());

    os << "function(name=" << registered_functions()[serial].name;
    for (exvector::const_iterator it=seq.begin(); it!=seq.end(); ++it) {
        os << ",";
        (*it).bp->print(os);
    }
    os << ")";
}

void function::print(ostream & os, unsigned upper_precedence) const
{
    debugmsg("function print",LOGLEVEL_PRINT);

    GINAC_ASSERT(serial<registered_functions().size());

    os << registered_functions()[serial].name;
    printseq(os,'(',',',')',exprseq::precedence,function::precedence);
}

void function::printtree(ostream & os, unsigned indent) const
{
    debugmsg("function printtree",LOGLEVEL_PRINT);

    GINAC_ASSERT(serial<registered_functions().size());

    os << string(indent,' ') << "function "
       << registered_functions()[serial].name
       << ", hash=" << hashvalue << " (0x" << hex << hashvalue << dec << ")"
       << ", flags=" << flags
       << ", nops=" << nops() << endl;
    for (unsigned i=0; i<nops(); ++i) {
        seq[i].printtree(os,indent+delta_indent);
    }
    os << string(indent+delta_indent,' ') << "=====" << endl;
}

void function::printcsrc(ostream & os, unsigned type, unsigned upper_precedence) const
{
    debugmsg("function print csrc",LOGLEVEL_PRINT);

    GINAC_ASSERT(serial<registered_functions().size());

	// Print function name in lowercase
    string lname;
    lname=registered_functions()[serial].name;
    for (unsigned i=0; i<lname.size(); i++)
        lname[i] = tolower(lname[i]);
    os << lname << "(";

	// Print arguments, separated by commas
    exvector::const_iterator it = seq.begin();
    exvector::const_iterator itend = seq.end();
    while (it != itend) {
        it->bp->printcsrc(os, type, 0);
        it++;
        if (it != itend)
            os << ",";
    }
    os << ")";
}

ex function::expand(unsigned options) const
{
    return this->setflag(status_flags::expanded);
}

ex function::eval(int level) const
{
    GINAC_ASSERT(serial<registered_functions().size());

    exvector eseq=evalchildren(level);    

    if (registered_functions()[serial].e==0) {
        return function(serial,eseq).hold();
    }
    switch (registered_functions()[serial].nparams) {
        // the following lines have been generated for max. 10 parameters
    case 1:
        return ((eval_funcp_1)(registered_functions()[serial].e))(eseq[1-1]);
        break;
    case 2:
        return ((eval_funcp_2)(registered_functions()[serial].e))(eseq[1-1], eseq[2-1]);
        break;
    case 3:
        return ((eval_funcp_3)(registered_functions()[serial].e))(eseq[1-1], eseq[2-1], eseq[3-1]);
        break;
    case 4:
        return ((eval_funcp_4)(registered_functions()[serial].e))(eseq[1-1], eseq[2-1], eseq[3-1], eseq[4-1]);
        break;
    case 5:
        return ((eval_funcp_5)(registered_functions()[serial].e))(eseq[1-1], eseq[2-1], eseq[3-1], eseq[4-1], eseq[5-1]);
        break;
    case 6:
        return ((eval_funcp_6)(registered_functions()[serial].e))(eseq[1-1], eseq[2-1], eseq[3-1], eseq[4-1], eseq[5-1], eseq[6-1]);
        break;
    case 7:
        return ((eval_funcp_7)(registered_functions()[serial].e))(eseq[1-1], eseq[2-1], eseq[3-1], eseq[4-1], eseq[5-1], eseq[6-1], eseq[7-1]);
        break;
    case 8:
        return ((eval_funcp_8)(registered_functions()[serial].e))(eseq[1-1], eseq[2-1], eseq[3-1], eseq[4-1], eseq[5-1], eseq[6-1], eseq[7-1], eseq[8-1]);
        break;
    case 9:
        return ((eval_funcp_9)(registered_functions()[serial].e))(eseq[1-1], eseq[2-1], eseq[3-1], eseq[4-1], eseq[5-1], eseq[6-1], eseq[7-1], eseq[8-1], eseq[9-1]);
        break;
    case 10:
        return ((eval_funcp_10)(registered_functions()[serial].e))(eseq[1-1], eseq[2-1], eseq[3-1], eseq[4-1], eseq[5-1], eseq[6-1], eseq[7-1], eseq[8-1], eseq[9-1], eseq[10-1]);
        break;

        // end of generated lines
    }
    throw(std::logic_error("function::eval(): invalid nparams"));
}

ex function::evalf(int level) const
{
    GINAC_ASSERT(serial<registered_functions().size());

    exvector eseq=evalfchildren(level);
    
    if (registered_functions()[serial].ef==0) {
        return function(serial,eseq).hold();
    }
    switch (registered_functions()[serial].nparams) {
        // the following lines have been generated for max. 10 parameters
    case 1:
        return ((evalf_funcp_1)(registered_functions()[serial].ef))(eseq[1-1]);
        break;
    case 2:
        return ((evalf_funcp_2)(registered_functions()[serial].ef))(eseq[1-1], eseq[2-1]);
        break;
    case 3:
        return ((evalf_funcp_3)(registered_functions()[serial].ef))(eseq[1-1], eseq[2-1], eseq[3-1]);
        break;
    case 4:
        return ((evalf_funcp_4)(registered_functions()[serial].ef))(eseq[1-1], eseq[2-1], eseq[3-1], eseq[4-1]);
        break;
    case 5:
        return ((evalf_funcp_5)(registered_functions()[serial].ef))(eseq[1-1], eseq[2-1], eseq[3-1], eseq[4-1], eseq[5-1]);
        break;
    case 6:
        return ((evalf_funcp_6)(registered_functions()[serial].ef))(eseq[1-1], eseq[2-1], eseq[3-1], eseq[4-1], eseq[5-1], eseq[6-1]);
        break;
    case 7:
        return ((evalf_funcp_7)(registered_functions()[serial].ef))(eseq[1-1], eseq[2-1], eseq[3-1], eseq[4-1], eseq[5-1], eseq[6-1], eseq[7-1]);
        break;
    case 8:
        return ((evalf_funcp_8)(registered_functions()[serial].ef))(eseq[1-1], eseq[2-1], eseq[3-1], eseq[4-1], eseq[5-1], eseq[6-1], eseq[7-1], eseq[8-1]);
        break;
    case 9:
        return ((evalf_funcp_9)(registered_functions()[serial].ef))(eseq[1-1], eseq[2-1], eseq[3-1], eseq[4-1], eseq[5-1], eseq[6-1], eseq[7-1], eseq[8-1], eseq[9-1]);
        break;
    case 10:
        return ((evalf_funcp_10)(registered_functions()[serial].ef))(eseq[1-1], eseq[2-1], eseq[3-1], eseq[4-1], eseq[5-1], eseq[6-1], eseq[7-1], eseq[8-1], eseq[9-1], eseq[10-1]);
        break;

        // end of generated lines
    }
    throw(std::logic_error("function::evalf(): invalid nparams"));
}

ex function::thisexprseq(const exvector & v) const
{
    return function(serial,v);
}

ex function::thisexprseq(exvector * vp) const
{
    return function(serial,vp);
}

/** Implementation of ex::series for functions.
 *  @see ex::series */
ex function::series(const symbol & s, const ex & point, int order) const
{
    GINAC_ASSERT(serial<registered_functions().size());

    if (registered_functions()[serial].s==0) {
        return basic::series(s, point, order);
    }
    ex res;
    switch (registered_functions()[serial].nparams) {
        // the following lines have been generated for max. 10 parameters
    case 1:
        try {
            res = ((series_funcp_1)(registered_functions()[serial].s))(seq[1-1],s,point,order);
        } catch (do_taylor) {
            res = basic::series(s, point, order);
        }
        return res;
        break;
    case 2:
        try {
            res = ((series_funcp_2)(registered_functions()[serial].s))(seq[1-1], seq[2-1],s,point,order);
        } catch (do_taylor) {
            res = basic::series(s, point, order);
        }
        return res;
        break;
    case 3:
        try {
            res = ((series_funcp_3)(registered_functions()[serial].s))(seq[1-1], seq[2-1], seq[3-1],s,point,order);
        } catch (do_taylor) {
            res = basic::series(s, point, order);
        }
        return res;
        break;
    case 4:
        try {
            res = ((series_funcp_4)(registered_functions()[serial].s))(seq[1-1], seq[2-1], seq[3-1], seq[4-1],s,point,order);
        } catch (do_taylor) {
            res = basic::series(s, point, order);
        }
        return res;
        break;
    case 5:
        try {
            res = ((series_funcp_5)(registered_functions()[serial].s))(seq[1-1], seq[2-1], seq[3-1], seq[4-1], seq[5-1],s,point,order);
        } catch (do_taylor) {
            res = basic::series(s, point, order);
        }
        return res;
        break;
    case 6:
        try {
            res = ((series_funcp_6)(registered_functions()[serial].s))(seq[1-1], seq[2-1], seq[3-1], seq[4-1], seq[5-1], seq[6-1],s,point,order);
        } catch (do_taylor) {
            res = basic::series(s, point, order);
        }
        return res;
        break;
    case 7:
        try {
            res = ((series_funcp_7)(registered_functions()[serial].s))(seq[1-1], seq[2-1], seq[3-1], seq[4-1], seq[5-1], seq[6-1], seq[7-1],s,point,order);
        } catch (do_taylor) {
            res = basic::series(s, point, order);
        }
        return res;
        break;
    case 8:
        try {
            res = ((series_funcp_8)(registered_functions()[serial].s))(seq[1-1], seq[2-1], seq[3-1], seq[4-1], seq[5-1], seq[6-1], seq[7-1], seq[8-1],s,point,order);
        } catch (do_taylor) {
            res = basic::series(s, point, order);
        }
        return res;
        break;
    case 9:
        try {
            res = ((series_funcp_9)(registered_functions()[serial].s))(seq[1-1], seq[2-1], seq[3-1], seq[4-1], seq[5-1], seq[6-1], seq[7-1], seq[8-1], seq[9-1],s,point,order);
        } catch (do_taylor) {
            res = basic::series(s, point, order);
        }
        return res;
        break;
    case 10:
        try {
            res = ((series_funcp_10)(registered_functions()[serial].s))(seq[1-1], seq[2-1], seq[3-1], seq[4-1], seq[5-1], seq[6-1], seq[7-1], seq[8-1], seq[9-1], seq[10-1],s,point,order);
        } catch (do_taylor) {
            res = basic::series(s, point, order);
        }
        return res;
        break;

        // end of generated lines
    }
    throw(std::logic_error("function::series(): invalid nparams"));
}

// protected


/** Implementation of ex::diff() for functions. It applies the chain rule,
 *  except for the Order term function.
 *  @see ex::diff */
ex function::derivative(const symbol & s) const
{
    ex result;
    
    if (serial==function_index_Order) {
        // Order Term function only differentiates the argument
        return Order(seq[0].diff(s));
    } else {
        // Chain rule
        ex arg_diff;
        for (unsigned i=0; i!=seq.size(); i++) {
            arg_diff = seq[i].diff(s);
            // We apply the chain rule only when it makes sense.  This is not
            // just for performance reasons but also to allow functions to
            // throw when differentiated with respect to one of its arguments
            // without running into trouble with our automatic full
            // differentiation:
            if (!arg_diff.is_zero())
                result += pderivative(i)*arg_diff;
        }
    }
    return result;
}

int function::compare_same_type(const basic & other) const
{
    GINAC_ASSERT(is_of_type(other, function));
    const function & o=static_cast<function &>(const_cast<basic &>(other));

    if (serial!=o.serial) {
        return serial < o.serial ? -1 : 1;
    }
    return exprseq::compare_same_type(o);
}

bool function::is_equal_same_type(const basic & other) const
{
    GINAC_ASSERT(is_of_type(other, function));
    const function & o=static_cast<function &>(const_cast<basic &>(other));

    if (serial!=o.serial) return false;
    return exprseq::is_equal_same_type(o);
}

unsigned function::return_type(void) const
{
    if (seq.size()==0) {
        return return_types::commutative;
    }
    return (*seq.begin()).return_type();
}
   
unsigned function::return_type_tinfo(void) const
{
    if (seq.size()==0) {
        return tinfo_key;
    }
    return (*seq.begin()).return_type_tinfo();
}

//////////
// new virtual functions which can be overridden by derived classes
//////////

// none

//////////
// non-virtual functions in this class
//////////

// protected

ex function::pderivative(unsigned diff_param) const // partial differentiation
{
    GINAC_ASSERT(serial<registered_functions().size());
    
    if (registered_functions()[serial].d==0) {
        throw(std::logic_error(string("function::pderivative(") + registered_functions()[serial].name + "): no diff function defined"));
    }
    switch (registered_functions()[serial].nparams) {
        // the following lines have been generated for max. 10 parameters
    case 1:
        return ((derivative_funcp_1)(registered_functions()[serial].d))(seq[1-1],diff_param);
        break;
    case 2:
        return ((derivative_funcp_2)(registered_functions()[serial].d))(seq[1-1], seq[2-1],diff_param);
        break;
    case 3:
        return ((derivative_funcp_3)(registered_functions()[serial].d))(seq[1-1], seq[2-1], seq[3-1],diff_param);
        break;
    case 4:
        return ((derivative_funcp_4)(registered_functions()[serial].d))(seq[1-1], seq[2-1], seq[3-1], seq[4-1],diff_param);
        break;
    case 5:
        return ((derivative_funcp_5)(registered_functions()[serial].d))(seq[1-1], seq[2-1], seq[3-1], seq[4-1], seq[5-1],diff_param);
        break;
    case 6:
        return ((derivative_funcp_6)(registered_functions()[serial].d))(seq[1-1], seq[2-1], seq[3-1], seq[4-1], seq[5-1], seq[6-1],diff_param);
        break;
    case 7:
        return ((derivative_funcp_7)(registered_functions()[serial].d))(seq[1-1], seq[2-1], seq[3-1], seq[4-1], seq[5-1], seq[6-1], seq[7-1],diff_param);
        break;
    case 8:
        return ((derivative_funcp_8)(registered_functions()[serial].d))(seq[1-1], seq[2-1], seq[3-1], seq[4-1], seq[5-1], seq[6-1], seq[7-1], seq[8-1],diff_param);
        break;
    case 9:
        return ((derivative_funcp_9)(registered_functions()[serial].d))(seq[1-1], seq[2-1], seq[3-1], seq[4-1], seq[5-1], seq[6-1], seq[7-1], seq[8-1], seq[9-1],diff_param);
        break;
    case 10:
        return ((derivative_funcp_10)(registered_functions()[serial].d))(seq[1-1], seq[2-1], seq[3-1], seq[4-1], seq[5-1], seq[6-1], seq[7-1], seq[8-1], seq[9-1], seq[10-1],diff_param);
        break;

        // end of generated lines
    }        
    throw(std::logic_error("function::pderivative(): no diff function defined"));
}

vector<registered_function_info> & function::registered_functions(void)
{
    static vector<registered_function_info> * rf=new vector<registered_function_info>;
    return *rf;
}

// public

// the following lines have been generated for max. 10 parameters
unsigned function::register_new(const char * nm, eval_funcp_1 e,
                                 evalf_funcp_1 ef, derivative_funcp_1 d, series_funcp_1 s)
{
    registered_function_info rfi={nm,1,0,eval_funcp(e),
                                  evalf_funcp(ef),derivative_funcp(d),series_funcp(s)};
    registered_functions().push_back(rfi);
    return registered_functions().size()-1;
}
unsigned function::register_new(const char * nm, eval_funcp_2 e,
                                 evalf_funcp_2 ef, derivative_funcp_2 d, series_funcp_2 s)
{
    registered_function_info rfi={nm,2,0,eval_funcp(e),
                                  evalf_funcp(ef),derivative_funcp(d),series_funcp(s)};
    registered_functions().push_back(rfi);
    return registered_functions().size()-1;
}
unsigned function::register_new(const char * nm, eval_funcp_3 e,
                                 evalf_funcp_3 ef, derivative_funcp_3 d, series_funcp_3 s)
{
    registered_function_info rfi={nm,3,0,eval_funcp(e),
                                  evalf_funcp(ef),derivative_funcp(d),series_funcp(s)};
    registered_functions().push_back(rfi);
    return registered_functions().size()-1;
}
unsigned function::register_new(const char * nm, eval_funcp_4 e,
                                 evalf_funcp_4 ef, derivative_funcp_4 d, series_funcp_4 s)
{
    registered_function_info rfi={nm,4,0,eval_funcp(e),
                                  evalf_funcp(ef),derivative_funcp(d),series_funcp(s)};
    registered_functions().push_back(rfi);
    return registered_functions().size()-1;
}
unsigned function::register_new(const char * nm, eval_funcp_5 e,
                                 evalf_funcp_5 ef, derivative_funcp_5 d, series_funcp_5 s)
{
    registered_function_info rfi={nm,5,0,eval_funcp(e),
                                  evalf_funcp(ef),derivative_funcp(d),series_funcp(s)};
    registered_functions().push_back(rfi);
    return registered_functions().size()-1;
}
unsigned function::register_new(const char * nm, eval_funcp_6 e,
                                 evalf_funcp_6 ef, derivative_funcp_6 d, series_funcp_6 s)
{
    registered_function_info rfi={nm,6,0,eval_funcp(e),
                                  evalf_funcp(ef),derivative_funcp(d),series_funcp(s)};
    registered_functions().push_back(rfi);
    return registered_functions().size()-1;
}
unsigned function::register_new(const char * nm, eval_funcp_7 e,
                                 evalf_funcp_7 ef, derivative_funcp_7 d, series_funcp_7 s)
{
    registered_function_info rfi={nm,7,0,eval_funcp(e),
                                  evalf_funcp(ef),derivative_funcp(d),series_funcp(s)};
    registered_functions().push_back(rfi);
    return registered_functions().size()-1;
}
unsigned function::register_new(const char * nm, eval_funcp_8 e,
                                 evalf_funcp_8 ef, derivative_funcp_8 d, series_funcp_8 s)
{
    registered_function_info rfi={nm,8,0,eval_funcp(e),
                                  evalf_funcp(ef),derivative_funcp(d),series_funcp(s)};
    registered_functions().push_back(rfi);
    return registered_functions().size()-1;
}
unsigned function::register_new(const char * nm, eval_funcp_9 e,
                                 evalf_funcp_9 ef, derivative_funcp_9 d, series_funcp_9 s)
{
    registered_function_info rfi={nm,9,0,eval_funcp(e),
                                  evalf_funcp(ef),derivative_funcp(d),series_funcp(s)};
    registered_functions().push_back(rfi);
    return registered_functions().size()-1;
}
unsigned function::register_new(const char * nm, eval_funcp_10 e,
                                 evalf_funcp_10 ef, derivative_funcp_10 d, series_funcp_10 s)
{
    registered_function_info rfi={nm,10,0,eval_funcp(e),
                                  evalf_funcp(ef),derivative_funcp(d),series_funcp(s)};
    registered_functions().push_back(rfi);
    return registered_functions().size()-1;
}

// end of generated lines

//////////
// static member variables
//////////

// none

//////////
// global constants
//////////

const function some_function;
const type_info & typeid_function=typeid(some_function);

#ifndef NO_NAMESPACE_GINAC
} // namespace GiNaC
#endif // ndef NO_NAMESPACE_GINAC

