/** @file lst.h
 *
 *  Definition of GiNaC's lst. */

/*
 *  This file was generated automatically by container.pl.
 *  Please do not modify it directly, edit the perl script instead!
 *  container.pl options: $CONTAINER=lst
 *                        $STLHEADER=list
 *                        $reserve=0
 *                        $prepend=1
 *                        $let_op=1
 *                        $open_bracket=[
 *                        $close_bracket=]
 *
 *  GiNaC Copyright (C) 1999-2000 Johannes Gutenberg University Mainz, Germany
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __GINAC_LST_H__
#define __GINAC_LST_H__

#include <list>

// CINT needs <algorithm> to work properly with <vector> and <list> 
#include <algorithm>

#include "basic.h"
#include "ex.h"

#ifndef NO_NAMESPACE_GINAC
namespace GiNaC {
#endif // ndef NO_NAMESPACE_GINAC

// typedef list<ex> exlist;
typedef list<ex,malloc_alloc> exlist; // CINT does not like list<...,default_alloc>

class lst : public basic
{
    GINAC_DECLARE_REGISTERED_CLASS(lst, basic)

public:
    lst();
    ~lst();
    lst(const lst & other);
    const lst & operator=(const lst & other);
protected:
    void copy(const lst & other);
    void destroy(bool call_parent);

public:
    lst(const exlist & s, bool discardable=0);
    lst(exlist * vp); // vp will be deleted
    explicit lst(const ex & e1);
    explicit lst(const ex & e1, const ex & e2);
    explicit lst(const ex & e1, const ex & e2, const ex & e3);
    explicit lst(const ex & e1, const ex & e2, const ex & e3,
             const ex & e4);
    explicit lst(const ex & e1, const ex & e2, const ex & e3,
             const ex & e4, const ex & e5);
    explicit lst(const ex & e1, const ex & e2, const ex & e3,
             const ex & e4, const ex & e5, const ex & e6);
    explicit lst(const ex & e1, const ex & e2, const ex & e3,
             const ex & e4, const ex & e5, const ex & e6,
             const ex & e7);
    explicit lst(const ex & e1, const ex & e2, const ex & e3,
             const ex & e4, const ex & e5, const ex & e6,
             const ex & e7, const ex & e8);
    explicit lst(const ex & e1, const ex & e2, const ex & e3,
             const ex & e4, const ex & e5, const ex & e6,
             const ex & e7, const ex & e8, const ex & e9);
    explicit lst(const ex & e1, const ex & e2, const ex & e3,
             const ex & e4, const ex & e5, const ex & e6,
             const ex & e7, const ex & e8, const ex & e9,
             const ex &e10);

public:
    basic * duplicate() const;
    void printraw(ostream & os) const;
    void print(ostream & os, unsigned upper_precedence=0) const;
    void printtree(ostream & os, unsigned indent) const;
    bool info(unsigned inf) const;
    unsigned nops() const;
    ex & let_op(int i);
    ex expand(unsigned options=0) const;
    bool has(const ex & other) const;
    ex eval(int level=0) const;
    ex evalf(int level=0) const;
    ex normal(lst &sym_lst, lst &repl_lst, int level=0) const;
    ex derivative(const symbol & s) const;
    ex subs(const lst & ls, const lst & lr) const;
protected:
    int compare_same_type(const basic & other) const;
    bool is_equal_same_type(const basic & other) const;
    unsigned return_type(void) const;

    // new virtual functions which can be overridden by derived classes
public:
    virtual lst & append(const ex & b);
    virtual lst & prepend(const ex & b);

protected:
    virtual void printseq(ostream & os, char openbracket, char delim,
                          char closebracket, unsigned this_precedence,
                          unsigned upper_precedence=0) const;
    virtual ex thislst(const exlist & v) const;
    virtual ex thislst(exlist * vp) const;

protected:
    bool is_canonical() const;
    exlist evalchildren(int level) const;
    exlist evalfchildren(int level) const;
    exlist normalchildren(int level) const;
    exlist diffchildren(const symbol & s) const;
    exlist * subschildren(const lst & ls, const lst & lr) const;

protected:
    exlist seq;
    static unsigned precedence;
};

// global constants

extern const lst some_lst;
extern const type_info & typeid_lst;

// utility functions
inline const lst &ex_to_lst(const ex &e)
{
    return static_cast<const lst &>(*e.bp);
}

#ifndef NO_NAMESPACE_GINAC
} // namespace GiNaC
#endif // ndef NO_NAMESPACE_GINAC

#endif // ndef __GINAC_LST_H__

